program EnumeratorWielkieLitery;

uses
  SysUtils;

type
  TPrzykładowyEnumerator = class
  private
    FTekst: string;
    FIndeks: integer;
  protected
    function GetCurrent: Char; virtual;
  public
    constructor Create(aTekst: string);
    function MoveNext: Boolean;
    property Current: Char read GetCurrent;
  end;

  TPrzykładowaKlasa = class
  private
    FPrzykładowyTekst: string;
    procedure WpiszTekst(const Wartość: string);
  public
    constructor Create(aTekst: string);
    function GetEnumerator: TPrzykładowyEnumerator;
    property Tekst: string read FPrzykładowyTekst write WpiszTekst;
  end;

constructor TPrzykładowyEnumerator.Create(aTekst: string);
begin
  FTekst := aTekst;
end;

function TPrzykładowyEnumerator.GetCurrent: Char;
begin
  Result := FTekst[FIndeks];
end;

function TPrzykładowyEnumerator.MoveNext: Boolean;
begin
  Result := FIndeks < FTekst.Length;
  if Result then
  begin
    Inc(FIndeks);
  end;
end;

constructor TPrzykładowaKlasa.Create(aTekst: string);
begin
  FPrzykładowyTekst := aTekst;
end;

procedure TPrzykładowaKlasa.WpiszTekst(const Wartość: string);
begin
  FPrzykładowyTekst := Wartość;
end;

function TPrzykładowaKlasa.GetEnumerator: TPrzykładowyEnumerator;
begin
  Result := TPrzykładowyEnumerator.Create(FPrzykładowyTekst);
end;

procedure PrzeglądajTekst;
var
  PrzykładowaKlasa: TPrzykładowaKlasa;
  Z: Char;
begin
  PrzykładowaKlasa := TPrzykładowaKlasa.Create('Witaj, świecie!');
  try
    for Z in PrzykładowaKlasa do
    begin
      Write(Z, ',');
    end;
    WriteLn;
  finally
    PrzykładowaKlasa.Free;
  end;
end;

type
  TEnumeratorWielkieLitery = class(TPrzykładowyEnumerator)
  protected
    function GetCurrent: Char; override;
  end;

function TEnumeratorWielkieLitery.GetCurrent: Char;
begin
  Result := UpCase(inherited GetCurrent);
end;

type
  TZamiennikEnumeratoraWielkieLitery = class
  private
    FWłaściciel: TPrzykładowaKlasa;
  public
    constructor Create(aWłaściciel: TPrzykładowaKlasa);
    function GetEnumerator: TEnumeratorWielkieLitery;
  end;

  TPrzykładowaNowaKlasa = class(TPrzykładowaKlasa)
  private
    WielkieLitery: TZamiennikEnumeratoraWielkieLitery;
  public
    constructor Create(aTekst: string);
    property PodajWielkąLiterę: TZamiennikEnumeratoraWielkieLitery read WielkieLitery;
  end;

constructor TPrzykładowaNowaKlasa.Create(aTekst: string);
begin
  inherited Create(aTekst);
  WielkieLitery := TZamiennikEnumeratoraWielkieLitery.Create(Self);
end;

constructor TZamiennikEnumeratoraWielkieLitery.Create(aWłaściciel: TPrzykładowaKlasa);
begin
  inherited Create;
  FWłaściciel := aWłaściciel;
end;

function TZamiennikEnumeratoraWielkieLitery.GetEnumerator: TEnumeratorWielkieLitery;
begin
  Result := TEnumeratorWielkieLitery.Create(FWłaściciel.FPrzykładowyTekst);
end;

procedure PrzeglądajWielkieLitery;
var
  Z: Char;
  PrzykładowaNowaKlasa: TPrzykładowaNowaKlasa;
begin
  PrzykładowaNowaKlasa := TPrzykładowaNowaKlasa.Create('Pozdrowienia');
  try
    for Z in PrzykładowaNowaKlasa.PodajWielkąLiterę do
    begin
      Write(Z, ',');
    end;
    WriteLn;
  finally
    PrzykładowaNowaKlasa.Free;
  end;
end;

begin
  PrzeglądajWielkieLitery;
  ReadLn;
end.